/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.fixed;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.Predicate2;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.Procedure;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Sets;
import shadow.palantir.driver.org.eclipse.collections.api.set.FixedSizeSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.MutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.AbstractMutableSet;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

abstract class AbstractMemoryEfficientMutableSet<T>
extends AbstractMutableSet<T>
implements FixedSizeSet<T> {
    AbstractMemoryEfficientMutableSet() {
    }

    protected int nullSafeHashCode(Object element) {
        return element == null ? 0 : element.hashCode();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot add to a fixed size set: " + this.getClass());
    }

    @Override
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        throw new UnsupportedOperationException("Cannot add to a fixed size set: " + this.getClass());
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size set: " + this.getClass());
    }

    @Override
    public boolean retainAllIterable(Iterable<?> iterable) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size set: " + this.getClass());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size set: " + this.getClass());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size set: " + this.getClass());
    }

    @Override
    public boolean removeAllIterable(Iterable<?> iterable) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size set: " + this.getClass());
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException("Cannot remove from a fixed size set: " + this.getClass());
    }

    @Override
    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        throw new UnsupportedOperationException("Cannot removeIfWith from a fixed size set: " + this.getClass());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear a fixed size set: " + this.getClass());
    }

    @Override
    public MutableSet<T> withAll(Iterable<? extends T> elements) {
        if (Iterate.isEmpty(elements)) {
            return this;
        }
        return Sets.fixedSize.ofAll(this.toList().withAll((Iterable)elements));
    }

    @Override
    public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
        if (Iterate.isEmpty(elements)) {
            return this;
        }
        return Sets.fixedSize.ofAll(this.toList().withoutAll((Iterable)elements));
    }

    @Override
    public FixedSizeSet<T> tap(Procedure<? super T> procedure) {
        this.each(procedure);
        return this;
    }

    @Override
    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return this.toSet().asParallel(executorService, batchSize);
    }

    protected abstract class MemoryEfficientSetIterator
    implements Iterator<T> {
        private int next;

        protected MemoryEfficientSetIterator() {
        }

        protected abstract T getElement(int var1);

        @Override
        public boolean hasNext() {
            return this.next < AbstractMemoryEfficientMutableSet.this.size();
        }

        @Override
        public T next() {
            return this.getElement(this.next++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from a fixed size set: " + this.getClass());
        }
    }
}

