/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.IntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.IntSets;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.IntIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.IntSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableIntSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.primitive.AbstractIntSet;

public abstract class AbstractImmutableIntSet
extends AbstractIntSet
implements ImmutableIntSet {
    @Override
    public ImmutableIntSet newWith(int element) {
        return IntHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableIntSet newWithout(int element) {
        return IntHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return IntHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public IntSet freeze() {
        return this;
    }

    @Override
    public ImmutableIntSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                IntIterator iterator = this.intIterator();
                while (iterator.hasNext()) {
                    MutableIntSet batch = IntSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

