/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.ShortIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortSets;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.ShortIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ShortSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.primitive.AbstractShortSet;

public abstract class AbstractImmutableShortSet
extends AbstractShortSet
implements ImmutableShortSet {
    @Override
    public ImmutableShortSet newWith(short element) {
        return ShortHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithout(short element) {
        return ShortHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithoutAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public ShortSet freeze() {
        return this;
    }

    @Override
    public ImmutableShortSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                ShortIterator iterator = this.shortIterator();
                while (iterator.hasNext()) {
                    MutableShortSet batch = ShortSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

