/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.BooleanIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.BooleanSets;
import shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableBooleanSetFactory;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableBooleanEmptySet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableFalseSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableTrueSet;

public class ImmutableBooleanSetFactoryImpl
implements ImmutableBooleanSetFactory {
    public static final ImmutableBooleanSetFactory INSTANCE = new ImmutableBooleanSetFactoryImpl();

    @Override
    public ImmutableBooleanSet empty() {
        return ImmutableBooleanEmptySet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet of() {
        return this.empty();
    }

    @Override
    public ImmutableBooleanSet with() {
        return this.empty();
    }

    @Override
    public ImmutableBooleanSet of(boolean one) {
        return this.with(one);
    }

    @Override
    public ImmutableBooleanSet with(boolean one) {
        return one ? ImmutableTrueSet.INSTANCE : ImmutableFalseSet.INSTANCE;
    }

    @Override
    public ImmutableBooleanSet of(boolean ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableBooleanSet with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        ImmutableBooleanSet result = ImmutableBooleanEmptySet.INSTANCE;
        for (boolean item : items) {
            result = result.newWith(item);
        }
        return result;
    }

    @Override
    public ImmutableBooleanSet ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableBooleanSet withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanSet) {
            return (ImmutableBooleanSet)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableBooleanSet ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableBooleanSet withAll(Iterable<Boolean> iterable) {
        return BooleanSets.mutable.withAll(iterable).toImmutable();
    }
}

