/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.CharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableCharSetFactory;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.CharSets;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharEmptySet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableCharSingletonSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

public class ImmutableCharSetFactoryImpl
implements ImmutableCharSetFactory {
    public static final ImmutableCharSetFactory INSTANCE = new ImmutableCharSetFactoryImpl();

    @Override
    public ImmutableCharSet empty() {
        return ImmutableCharEmptySet.INSTANCE;
    }

    @Override
    public ImmutableCharSet of() {
        return this.empty();
    }

    @Override
    public ImmutableCharSet with() {
        return this.empty();
    }

    @Override
    public ImmutableCharSet of(char one) {
        return this.with(one);
    }

    @Override
    public ImmutableCharSet with(char one) {
        return new ImmutableCharSingletonSet(one);
    }

    @Override
    public ImmutableCharSet of(char ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableCharSet with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return CharHashSet.newSetWith(items).toImmutable();
    }

    @Override
    public ImmutableCharSet ofAll(CharIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableCharSet withAll(CharIterable items) {
        if (items instanceof ImmutableCharSet) {
            return (ImmutableCharSet)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableCharSet ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableCharSet withAll(Iterable<Character> iterable) {
        return CharSets.mutable.withAll(iterable).toImmutable();
    }
}

