/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.DoubleSet;
import shadow.palantir.driver.org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

public final class ImmutableDoubleSetSerializationProxy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private DoubleSet set;

    public ImmutableDoubleSetSerializationProxy() {
    }

    public ImmutableDoubleSetSerializationProxy(DoubleSet set) {
        this.set = set;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.set.size());
        try {
            this.set.forEach(new CheckedDoubleProcedure(){

                @Override
                public void safeValue(double item) throws Exception {
                    out.writeDouble(item);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        DoubleHashSet deserializedSet = new DoubleHashSet(size);
        for (int i = 0; i < size; ++i) {
            deserializedSet.add(in.readDouble());
        }
        this.set = deserializedSet;
    }

    private Object readResolve() {
        return this.set.toImmutable();
    }
}

