/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive;

import java.util.stream.IntStream;
import shadow.palantir.driver.org.eclipse.collections.api.IntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.ImmutableIntSetFactory;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.IntSets;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntEmptySet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSingletonSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public class ImmutableIntSetFactoryImpl
implements ImmutableIntSetFactory {
    public static final ImmutableIntSetFactory INSTANCE = new ImmutableIntSetFactoryImpl();

    @Override
    public ImmutableIntSet empty() {
        return ImmutableIntEmptySet.INSTANCE;
    }

    @Override
    public ImmutableIntSet of() {
        return this.empty();
    }

    @Override
    public ImmutableIntSet with() {
        return this.empty();
    }

    @Override
    public ImmutableIntSet of(int one) {
        return this.with(one);
    }

    @Override
    public ImmutableIntSet with(int one) {
        return new ImmutableIntSingletonSet(one);
    }

    @Override
    public ImmutableIntSet of(int ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableIntSet with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return IntHashSet.newSetWith(items).toImmutable();
    }

    @Override
    public ImmutableIntSet ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntSet withAll(IntIterable items) {
        if (items instanceof ImmutableIntSet) {
            return (ImmutableIntSet)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableIntSet ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableIntSet withAll(Iterable<Integer> iterable) {
        return IntSets.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableIntSet ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntSet withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

