/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyShortIterable;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.ShortIterable;
import shadow.palantir.driver.org.eclipse.collections.api.bag.primitive.MutableShortBag;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Sets;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortBags;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortLists;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.ShortIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.primitive.MutableShortList;
import shadow.palantir.driver.org.eclipse.collections.api.set.ImmutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ShortSet;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.primitive.ShortShortPair;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.ShortSets;
import shadow.palantir.driver.org.eclipse.collections.impl.iterator.SingletonShortIterator;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

final class ImmutableShortSingletonSet
implements ImmutableShortSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short element;

    ImmutableShortSingletonSet(short element) {
        this.element = element;
    }

    @Override
    public ImmutableShortSet newWith(short element) {
        return ShortSets.immutable.with(this.element, element);
    }

    @Override
    public ImmutableShortSet newWithout(short element) {
        return this.element == element ? ShortSets.immutable.with() : this;
    }

    @Override
    public ImmutableShortSet newWithAll(ShortIterable elements) {
        return ShortHashSet.newSet(elements).with(this.element).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithoutAll(ShortIterable elements) {
        return elements.contains(this.element) ? ShortSets.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public boolean contains(short value) {
        return this.element == value;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void each(ShortProcedure procedure) {
        procedure.value(this.element);
    }

    @Override
    public ImmutableShortSet select(ShortPredicate predicate) {
        return predicate.accept(this.element) ? ShortHashSet.newSetWith(this.element).toImmutable() : new ShortHashSet().toImmutable();
    }

    @Override
    public ImmutableShortSet reject(ShortPredicate predicate) {
        return predicate.accept(this.element) ? new ShortHashSet().toImmutable() : ShortHashSet.newSetWith(this.element).toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        return Sets.immutable.with(function.valueOf(this.element));
    }

    @Override
    public MutableShortList toList() {
        return ShortLists.mutable.with(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(short item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure) {
        shortIntProcedure.value(this.element, 1);
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    @Override
    public int count(ShortPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element);
    }

    @Override
    public long sum() {
        return this.element;
    }

    @Override
    public short min() {
        return this.element;
    }

    @Override
    public short max() {
        return this.element;
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.element;
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.element;
    }

    @Override
    public double average() {
        return this.element;
    }

    @Override
    public double median() {
        return this.element;
    }

    @Override
    public LazyIterable<ShortShortPair> cartesianProduct(ShortSet set) {
        return ShortSets.cartesianProduct(this, set);
    }

    @Override
    public short[] toSortedArray() {
        return new short[]{this.element};
    }

    @Override
    public MutableShortList toSortedList() {
        return ShortLists.mutable.with(this.element);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.element);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.element);
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortSet)) {
            return false;
        }
        ShortSet set = (ShortSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    @Override
    public int hashCode() {
        return this.element;
    }

    @Override
    public MutableShortSet toSet() {
        return ShortSets.mutable.with(this.element);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortBags.mutable.with(this.element);
    }

    @Override
    public ShortSet freeze() {
        return this;
    }

    @Override
    public ImmutableShortSet toImmutable() {
        return this;
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public short[] toArray() {
        return new short[]{this.element};
    }

    @Override
    public short[] toArray(short[] target) {
        if (target.length < 1) {
            target = new short[]{this.element};
        } else {
            target[0] = this.element;
        }
        return target;
    }

    @Override
    public String toString() {
        return '[' + this.makeString() + ']';
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ShortIterator shortIterator() {
        return new SingletonShortIterator(this.element);
    }
}

