/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive;

import java.util.stream.LongStream;
import shadow.palantir.driver.org.eclipse.collections.api.LongIterable;
import shadow.palantir.driver.org.eclipse.collections.api.factory.set.primitive.MutableLongSetFactory;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableLongSet;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.LongSets;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;

public class MutableLongSetFactoryImpl
implements MutableLongSetFactory {
    public static final MutableLongSetFactory INSTANCE = new MutableLongSetFactoryImpl();

    @Override
    public MutableLongSet empty() {
        return new LongHashSet();
    }

    @Override
    public MutableLongSet of() {
        return this.empty();
    }

    @Override
    public MutableLongSet with() {
        return this.empty();
    }

    @Override
    public MutableLongSet withInitialCapacity(int capacity) {
        return new LongHashSet(capacity);
    }

    @Override
    public MutableLongSet of(long ... items) {
        return this.with(items);
    }

    @Override
    public MutableLongSet with(long ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return LongHashSet.newSetWith(items);
    }

    @Override
    public MutableLongSet ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongSet withAll(LongIterable items) {
        return LongHashSet.newSet(items);
    }

    @Override
    public MutableLongSet ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableLongSet withAll(Iterable<Long> iterable) {
        return Iterate.collectLong(iterable, Long::longValue, LongSets.mutable.empty());
    }

    @Override
    public MutableLongSet ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongSet withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

