/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import shadow.palantir.driver.org.eclipse.collections.api.RichIterable;
import shadow.palantir.driver.org.eclipse.collections.api.ShortIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Lists;
import shadow.palantir.driver.org.eclipse.collections.api.factory.primitive.ShortSets;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.MutableShortIterator;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.ShortIterator;
import shadow.palantir.driver.org.eclipse.collections.api.list.MutableList;
import shadow.palantir.driver.org.eclipse.collections.api.set.ImmutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.MutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.MutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.primitive.ShortSet;
import shadow.palantir.driver.org.eclipse.collections.impl.SpreadFunctions;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableShortSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortSetSerializationProxy;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.UnifiedSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.SynchronizedShortSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.primitive.AbstractShortSet;

public class ShortHashSet
extends AbstractShortSet
implements MutableShortSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final short EMPTY = 0;
    private static final short REMOVED = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private short[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public ShortHashSet() {
        this.allocateTable(16);
    }

    public ShortHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public ShortHashSet(short ... elements) {
        this();
        this.addAll(elements);
    }

    public ShortHashSet(ShortIterable elements) {
        this();
        this.addAll(elements);
    }

    public ShortHashSet(ShortHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public static ShortHashSet newSet(ShortIterable source) {
        if (source instanceof ShortHashSet) {
            return new ShortHashSet((ShortHashSet)source);
        }
        return new ShortHashSet(source);
    }

    public static ShortHashSet newSetWith(short ... source) {
        return new ShortHashSet(source);
    }

    private static boolean isBetweenZeroAndThirtyOne(short value) {
        return value >= 0 && value <= 31;
    }

    @Override
    public int hashCode() {
        short value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += value;
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
                result += this.table[i];
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            short value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean add(short element) {
        if (ShortHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (this.table[index] == element) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (this.table[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    @Override
    public boolean addAll(short ... source) {
        int oldSize = this.size();
        for (short item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean addAll(ShortIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ShortHashSet) {
            ShortHashSet hashSet = (ShortHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (short item : hashSet.table) {
                if (!ShortHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                short item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean remove(short value) {
        if (ShortHashSet.isBetweenZeroAndThirtyOne(value)) {
            return this.removeZeroToThirtyOne(value);
        }
        if (this.occupiedWithData == 0) {
            return false;
        }
        int index = this.probe(value);
        if (this.table[index] == value) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return true;
        }
        return false;
    }

    private boolean removeZeroToThirtyOne(short value) {
        int initial = this.zeroToThirtyOne;
        this.zeroToThirtyOne &= ~(1 << value);
        if (this.zeroToThirtyOne == initial) {
            return false;
        }
        --this.zeroToThirtyOneOccupied;
        return true;
    }

    @Override
    public boolean removeAll(ShortIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ShortHashSet) {
            ShortHashSet hashSet = (ShortHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (short item : hashSet.table) {
                if (!ShortHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                short item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(short ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (short item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(ShortIterable source) {
        int oldSize = this.size();
        ShortSet sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
        ShortHashSet retained = this.select(sourceSet::contains);
        if (retained.size() != oldSize) {
            this.zeroToThirtyOne = retained.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = retained.zeroToThirtyOneOccupied;
            this.occupiedWithData = retained.occupiedWithData;
            this.occupiedWithSentinels = retained.occupiedWithSentinels;
            this.table = retained.table;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(short ... source) {
        return this.retainAll(ShortHashSet.newSetWith(source));
    }

    @Override
    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new short[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, (short)0);
        }
    }

    @Override
    public ShortHashSet with(short element) {
        this.add(element);
        return this;
    }

    @Override
    public ShortHashSet without(short element) {
        this.remove(element);
        return this;
    }

    @Override
    public ShortHashSet withAll(ShortIterable elements) {
        this.addAll(elements);
        return this;
    }

    @Override
    public ShortHashSet withoutAll(ShortIterable elements) {
        this.removeAll(elements);
        return this;
    }

    @Override
    public MutableShortSet asUnmodifiable() {
        return new UnmodifiableShortSet(this);
    }

    @Override
    public MutableShortSet asSynchronized() {
        return new SynchronizedShortSet(this);
    }

    @Override
    public ImmutableShortSet toImmutable() {
        ShortHashSet mutableSet;
        if (this.size() == 0) {
            return ShortSets.immutable.with();
        }
        if (this.size() == 1) {
            return ShortSets.immutable.with(this.shortIterator().next());
        }
        if (this.table.length == this.smallestPowerOfTwoGreaterThan(this.size() << 1)) {
            mutableSet = this;
            this.copyOnWrite = true;
        } else {
            mutableSet = new ShortHashSet(this.size());
            mutableSet.addAll(this);
        }
        return new ImmutableShortHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    @Override
    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    @Override
    public short[] toArray() {
        short value;
        short[] array = new short[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            array[j] = value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    @Override
    public short[] toArray(short[] array) {
        short value;
        if (array.length < this.size()) {
            array = new short[this.size()];
        }
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            array[j] = value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    @Override
    public boolean contains(short value) {
        if (ShortHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> value & 1) != 0;
        }
        return this.table[this.probe(value)] == value;
    }

    @Override
    public void each(ShortProcedure procedure) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    @Override
    public ShortHashSet select(ShortPredicate predicate) {
        return this.select(predicate, new ShortHashSet());
    }

    @Override
    public <R extends MutableShortCollection> R select(ShortPredicate predicate, R target) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            target.add(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public ShortHashSet reject(ShortPredicate predicate) {
        return this.reject(predicate, new ShortHashSet());
    }

    @Override
    public <R extends MutableShortCollection> R reject(ShortPredicate predicate, R target) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            target.add(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.collect(function, UnifiedSet.newSet(this.size()));
    }

    @Override
    public <V, R extends Collection<V>> R collect(ShortToObjectFunction<? extends V> function, R target) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    @Override
    public int count(ShortPredicate predicate) {
        short value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        short value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long sum() {
        short value;
        long result = 0L;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (long)value;
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            result += (long)value2;
        }
        return result;
    }

    @Override
    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short max = (short)(31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne));
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (short value : this.table) {
            if (!ShortHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short min = (short)Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (short value : this.table) {
            if (!ShortHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    @Override
    public ShortSet freeze() {
        if (this.size() == 0) {
            return ShortSets.immutable.with();
        }
        if (this.size() == 1) {
            return ShortSets.immutable.with(this.shortIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableShortHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        short value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeShort(value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            out.writeShort(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readShort());
        }
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        short value;
        T result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (short value2 : this.table) {
            if (!ShortHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<ShortIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(ShortSets.mutable.withAll(this));
            } else {
                MutableShortIterator iterator = this.shortIterator();
                while (iterator.hasNext()) {
                    MutableShortSet batch = ShortSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add(batch);
                }
            }
        }
        return result;
    }

    @Override
    public ShortHashSet newEmpty() {
        return new ShortHashSet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        short[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ShortHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    protected void allocateTable(int sizeToAllocate) {
        this.table = new short[sizeToAllocate];
    }

    int probe(short element) {
        int index = this.spreadAndMask(element);
        short valueAtIndex = this.table[index];
        if (valueAtIndex == element || valueAtIndex == 0) {
            return index;
        }
        int removedIndex = valueAtIndex == 1 ? index : -1;
        for (int i = 1; i < 16; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            valueAtIndex = this.table[nextIndex];
            if (valueAtIndex == element) {
                return nextIndex;
            }
            if (valueAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(short element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 16; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            short valueAtIndex = this.table[nextIndex];
            if (valueAtIndex == element) {
                return nextIndex;
            }
            if (valueAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(short element, int removedIndex) {
        int nextIndex = Integer.reverse(SpreadFunctions.shortSpreadOne(element));
        int spreadTwo = Integer.reverse(SpreadFunctions.shortSpreadTwo(element)) | 1;
        short valueAtIndex;
        while ((valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (valueAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (valueAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(short element) {
        int code = SpreadFunctions.shortSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(short element) {
        int code = SpreadFunctions.shortSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        short[] copy = new short[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, this.table.length);
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        return this.table.length >> 1;
    }

    private static boolean isNonSentinel(short value) {
        return value != 0 && value != 1;
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private short zeroToThirtyOne;

        private InternalShortIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ShortHashSet.this.size();
        }

        @Override
        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32) {
                if (ShortHashSet.this.contains(this.zeroToThirtyOne)) {
                    short result = this.zeroToThirtyOne;
                    this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
                    return result;
                }
                this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
            }
            short[] table = ShortHashSet.this.table;
            while (!ShortHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            short result = table[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            short removeValue;
            if (this.count == 0) {
                throw new IllegalStateException();
            }
            if (this.zeroToThirtyOne <= 32 && this.position == 0) {
                if (ShortHashSet.this.zeroToThirtyOne != (ShortHashSet.this.zeroToThirtyOne | 1 << this.zeroToThirtyOne - 1)) {
                    throw new IllegalStateException();
                }
                removeValue = (short)(this.zeroToThirtyOne - 1);
            } else {
                if (ShortHashSet.this.table[this.position - 1] == 1) {
                    throw new IllegalStateException();
                }
                removeValue = ShortHashSet.this.table[this.position - 1];
            }
            if (ShortHashSet.isBetweenZeroAndThirtyOne(removeValue)) {
                ShortHashSet.this.removeZeroToThirtyOne(removeValue);
            } else if (ShortHashSet.this.table[this.position - 1] == removeValue) {
                if (ShortHashSet.this.copyOnWrite) {
                    ShortHashSet.this.copyTable();
                }
                ((ShortHashSet)ShortHashSet.this).table[this.position - 1] = 1;
                ShortHashSet.this.occupiedWithData--;
                ShortHashSet.this.occupiedWithSentinels++;
            }
            --this.count;
        }
    }

    private static final class ImmutableShortHashSet
    extends AbstractImmutableShortSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final short[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableShortHashSet(short[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use ShortSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableShortSet newSetWith(short ... elements) {
            return ShortHashSet.newSetWith(elements).toImmutable();
        }

        @Override
        public int hashCode() {
            short value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += value;
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
                    result += this.table[i];
                }
            }
            return result;
        }

        @Override
        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                short value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                    value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (short value2 : this.table) {
                    if (!ShortHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ShortIterator shortIterator() {
            return new InternalShortIterator();
        }

        @Override
        public short[] toArray() {
            short value;
            short[] array = new short[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                array[j] = value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        @Override
        public short[] toArray(short[] array) {
            short value;
            if (array.length < this.size()) {
                array = new short[this.size()];
            }
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                array[j] = value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!ShortHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        @Override
        public boolean contains(short value) {
            if (ShortHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> value & 1) != 0;
            }
            return this.table[this.probe(value)] == value;
        }

        @Override
        public void each(ShortProcedure procedure) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        @Override
        public ImmutableShortSet select(ShortPredicate predicate) {
            return this.select(predicate, new ShortHashSet()).toImmutable();
        }

        @Override
        public ImmutableShortSet reject(ShortPredicate predicate) {
            return this.reject(predicate, new ShortHashSet()).toImmutable();
        }

        @Override
        public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
            MutableSet set = this.collect(function, UnifiedSet.newSet(this.size()));
            return set.toImmutable();
        }

        @Override
        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        @Override
        public int count(ShortPredicate predicate) {
            short value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(ShortPredicate predicate) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(ShortPredicate predicate) {
            short value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(ShortPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        @Override
        public long sum() {
            short value;
            long result = 0L;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (long)value;
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                result += (long)value2;
            }
            return result;
        }

        @Override
        public short max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short max = (short)(31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne));
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (short value : this.table) {
                if (!ShortHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        @Override
        public short min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            short min = (short)Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (short value : this.table) {
                if (!ShortHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            short value;
            T result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = (short)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (short value2 : this.table) {
                if (!ShortHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        private Object writeReplace() {
            return new ImmutableShortSetSerializationProxy(this);
        }

        int probe(short element) {
            int index = this.spreadAndMask(element);
            short valueAtIndex = this.table[index];
            if (valueAtIndex == element || valueAtIndex == 0) {
                return index;
            }
            int removedIndex = valueAtIndex == 1 ? index : -1;
            for (int i = 1; i < 16; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                valueAtIndex = this.table[nextIndex];
                if (valueAtIndex == element) {
                    return nextIndex;
                }
                if (valueAtIndex == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeTwo(element, removedIndex);
        }

        int probeTwo(short element, int removedIndex) {
            int index = this.spreadTwoAndMask(element);
            for (int i = 0; i < 16; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                short valueAtIndex = this.table[nextIndex];
                if (valueAtIndex == element) {
                    return nextIndex;
                }
                if (valueAtIndex == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeThree(element, removedIndex);
        }

        int probeThree(short element, int removedIndex) {
            int nextIndex = Integer.reverse(SpreadFunctions.shortSpreadOne(element));
            int spreadTwo = Integer.reverse(SpreadFunctions.shortSpreadTwo(element)) | 1;
            short valueAtIndex;
            while ((valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
                if (valueAtIndex == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (valueAtIndex != 1 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return nextIndex;
        }

        int spreadAndMask(short element) {
            int code = SpreadFunctions.shortSpreadOne(element);
            return this.mask(code);
        }

        int spreadTwoAndMask(short element) {
            int code = SpreadFunctions.shortSpreadTwo(element);
            return this.mask(code);
        }

        private int mask(int spread) {
            return spread & this.table.length - 1;
        }

        private class InternalShortIterator
        implements ShortIterator {
            private int count;
            private int position;
            private short zeroToThirtyOne;

            private InternalShortIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.count < ImmutableShortHashSet.this.size();
            }

            @Override
            public short next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32) {
                    if (ImmutableShortHashSet.this.contains(this.zeroToThirtyOne)) {
                        short result = this.zeroToThirtyOne;
                        this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
                        return result;
                    }
                    this.zeroToThirtyOne = (short)(this.zeroToThirtyOne + 1);
                }
                short[] table = ImmutableShortHashSet.this.table;
                while (!ShortHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                short result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

