/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.tuple;

import java.util.Map;
import java.util.Objects;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.Pair;
import shadow.palantir.driver.org.eclipse.collections.impl.tuple.ImmutableEntry;

class PairImpl<T1, T2>
implements Pair<T1, T2> {
    private static final long serialVersionUID = 1L;
    private final T1 one;
    private final T2 two;

    PairImpl(T1 newOne, T2 newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public T1 getOne() {
        return this.one;
    }

    @Override
    public T2 getTwo() {
        return this.two;
    }

    @Override
    public void put(Map<? super T1, ? super T2> map) {
        map.put(this.one, this.two);
    }

    @Override
    public PairImpl<T2, T1> swap() {
        return new PairImpl<T2, T1>(this.two, this.one);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        return Objects.equals(this.one, that.getOne()) && Objects.equals(this.two, that.getTwo());
    }

    public int hashCode() {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + (this.two == null ? 0 : this.two.hashCode());
        return result;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public Map.Entry<T1, T2> toEntry() {
        return ImmutableEntry.of(this.one, this.two);
    }

    @Override
    public int compareTo(Pair<T1, T2> other) {
        int i = ((Comparable)this.one).compareTo(other.getOne());
        if (i != 0) {
            return i;
        }
        return ((Comparable)this.two).compareTo(other.getTwo());
    }
}

