/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.tuple.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.tuple.primitive.FloatObjectPair;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.Comparators;

public class FloatObjectPairImpl<T>
implements FloatObjectPair<T> {
    private static final long serialVersionUID = 1L;
    private final float one;
    private final T two;

    FloatObjectPairImpl(float newOne, T newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public float getOne() {
        return this.one;
    }

    @Override
    public T getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatObjectPair)) {
            return false;
        }
        FloatObjectPair that = (FloatObjectPair)o;
        return Float.compare(this.one, that.getOne()) == 0 && Comparators.nullSafeEquals(this.two, that.getTwo());
    }

    public int hashCode() {
        return 29 * Float.floatToIntBits(this.one) + (this.two == null ? 0 : this.two.hashCode());
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(FloatObjectPair<T> that) {
        int i = Float.compare(this.one, that.getOne());
        if (i != 0) {
            return i;
        }
        return ((Comparable)this.two).compareTo(that.getTwo());
    }
}

