/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.tuple.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.tuple.primitive.ObjectDoublePair;
import shadow.palantir.driver.org.eclipse.collections.impl.block.factory.Comparators;

public class ObjectDoublePairImpl<T>
implements ObjectDoublePair<T> {
    private static final long serialVersionUID = 1L;
    private final T one;
    private final double two;

    ObjectDoublePairImpl(T newOne, double newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public T getOne() {
        return this.one;
    }

    @Override
    public double getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectDoublePair)) {
            return false;
        }
        ObjectDoublePair that = (ObjectDoublePair)o;
        return Comparators.nullSafeEquals(this.one, that.getOne()) && Double.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + (int)(Double.doubleToLongBits(this.two) ^ Double.doubleToLongBits(this.two) >>> 32);
        return result;
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(ObjectDoublePair<T> that) {
        int i = ((Comparable)this.one).compareTo(that.getOne());
        if (i != 0) {
            return i;
        }
        return Double.compare(this.two, that.getTwo());
    }
}

