/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.utility.internal;

import java.util.Set;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.Function2;
import shadow.palantir.driver.org.eclipse.collections.api.factory.Sets;
import shadow.palantir.driver.org.eclipse.collections.api.set.ImmutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.MutableSet;
import shadow.palantir.driver.org.eclipse.collections.api.set.SetIterable;
import shadow.palantir.driver.org.eclipse.collections.api.tuple.Pair;
import shadow.palantir.driver.org.eclipse.collections.impl.set.mutable.UnifiedSet;
import shadow.palantir.driver.org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import shadow.palantir.driver.org.eclipse.collections.impl.tuple.Tuples;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.Iterate;
import shadow.palantir.driver.org.eclipse.collections.impl.utility.LazyIterate;

public final class SetIterables {
    private SetIterables() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <E> MutableSet<E> union(SetIterable<? extends E> setA, SetIterable<? extends E> setB) {
        if (setB.size() > setA.size()) {
            SetIterable<E> tmp = setA;
            setA = setB;
            setB = tmp;
        }
        return UnifiedSet.newSet(setA).withAll(setB);
    }

    public static <E, R extends Set<E>> R unionInto(SetIterable<? extends E> setA, SetIterable<? extends E> setB, R targetSet) {
        Iterate.addAllIterable(setA, targetSet);
        Iterate.addAllIterable(setB, targetSet);
        return targetSet;
    }

    public static <E> MutableSet<E> intersect(SetIterable<? extends E> setA, SetIterable<? extends E> setB) {
        return SetIterables.intersectInto(setA, setB, Sets.mutable.empty());
    }

    public static <E, R extends Set<E>> R intersectInto(SetIterable<? extends E> setA, SetIterable<? extends E> setB, R targetSet) {
        if (setB.size() < setA.size()) {
            SetIterable<E> tmp = setA;
            setA = setB;
            setB = tmp;
        }
        SetIterable<E> one = setA;
        return one.select(setB::contains, targetSet);
    }

    public static <E> MutableSet<E> difference(SetIterable<? extends E> minuendSet, SetIterable<? extends E> subtrahendSet) {
        return SetIterables.differenceInto(minuendSet, subtrahendSet, Sets.mutable.empty());
    }

    public static <E, R extends Set<E>> R differenceInto(SetIterable<? extends E> minuendSet, SetIterable<? extends E> subtrahendSet, R targetSet) {
        SetIterable<E> one = minuendSet;
        return one.reject(subtrahendSet::contains, targetSet);
    }

    public static <E> MutableSet<E> symmetricDifference(SetIterable<? extends E> setA, SetIterable<? extends E> setB) {
        return SetIterables.symmetricDifferenceInto(setA, setB, Sets.mutable.empty());
    }

    public static <E, R extends Set<E>> R symmetricDifferenceInto(SetIterable<? extends E> setA, SetIterable<? extends E> setB, R targetSet) {
        return SetIterables.unionInto(SetIterables.difference(setA, setB), SetIterables.difference(setB, setA), targetSet);
    }

    public static <E> boolean isSubsetOf(SetIterable<? extends E> candidateSubset, SetIterable<? extends E> candidateSuperset) {
        return candidateSubset.size() <= candidateSuperset.size() && candidateSuperset.containsAllIterable(candidateSubset);
    }

    public static <E> boolean isProperSubsetOf(SetIterable<? extends E> candidateSubset, SetIterable<? extends E> candidateSuperset) {
        return candidateSubset.size() < candidateSuperset.size() && candidateSuperset.containsAllIterable(candidateSubset);
    }

    public static <T> MutableSet<MutableSet<T>> powerSet(Set<T> set) {
        UnifiedSet<MutableSet<T>> seed = UnifiedSet.newSetWith(Sets.mutable.empty());
        return SetIterables.powerSetWithSeed(set, seed);
    }

    public static <T> MutableSet<MutableSet<T>> powerSet(UnifiedSetWithHashingStrategy<T> set) {
        UnifiedSet<MutableSet<T>> seed = UnifiedSet.newSetWith(set.newEmpty());
        return SetIterables.powerSetWithSeed(set, seed);
    }

    private static <T> MutableSet<MutableSet<T>> powerSetWithSeed(Set<T> set, MutableSet<MutableSet<T>> seed) {
        return Iterate.injectInto(seed, set, (accumulator, element) -> SetIterables.union(accumulator, accumulator.collect(innerSet -> innerSet.clone().with(element))));
    }

    public static <T> ImmutableSet<ImmutableSet<T>> immutablePowerSet(Set<T> set) {
        return SetIterables.powerSet(set).collect(MutableSet::toImmutable).toImmutable();
    }

    public static <A, B> LazyIterable<Pair<A, B>> cartesianProduct(SetIterable<A> set1, SetIterable<B> set2) {
        return SetIterables.cartesianProduct(set1, set2, Tuples::pair);
    }

    public static <A, B, C> LazyIterable<C> cartesianProduct(SetIterable<A> set1, SetIterable<B> set2, Function2<A, B, C> function) {
        return LazyIterate.cartesianProduct(set1, set2, function);
    }
}

