/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import shadow.palantir.driver.org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import shadow.palantir.driver.org.eclipse.collections.api.iterator.DoubleIterator;

public final class DoubleIteratorIterate {
    private DoubleIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(DoubleIterator iterator, DoubleProcedure procedure) {
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public static <R extends MutableDoubleCollection> R select(DoubleIterator iterator, DoublePredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            double item = iterator.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableDoubleCollection> R reject(DoubleIterator iterator, DoublePredicate predicate, R targetCollection) {
        while (iterator.hasNext()) {
            double item = iterator.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(DoubleIterator iterator, DoubleToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator.hasNext()) {
            double item = iterator.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static double detectIfNone(DoubleIterator iterator, DoublePredicate predicate, double ifNone) {
        while (iterator.hasNext()) {
            double item = iterator.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(DoubleIterator iterator, DoublePredicate predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean anySatisfy(DoubleIterator iterator, DoublePredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(DoubleIterator iterator, DoublePredicate predicate) {
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(DoubleIterator iterator, DoublePredicate predicate) {
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(DoubleIterator iterator, T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public static double sum(DoubleIterator iterator) {
        double sum = 0.0;
        while (iterator.hasNext()) {
            sum += iterator.next();
        }
        return sum;
    }

    public static double max(DoubleIterator iterator) {
        double max = iterator.next();
        while (iterator.hasNext()) {
            double next = iterator.next();
            if (Double.compare(max, next) >= 0) continue;
            max = next;
        }
        return max;
    }

    public static double min(DoubleIterator iterator) {
        double min = iterator.next();
        while (iterator.hasNext()) {
            double next = iterator.next();
            if (Double.compare(next, min) >= 0) continue;
            min = next;
        }
        return min;
    }
}

