/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.utility.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.CharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyCharIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.CharLists;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.CollectCharToObjectIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.FlatCollectCharToObjectIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.SelectCharIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.TapCharIterable;

public final class LazyCharIterate {
    private static final LazyCharIterable EMPTY_ITERABLE = CharLists.immutable.empty().asLazy();

    private LazyCharIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyCharIterable adapt(CharIterable iterable) {
        return new LazyCharIterableAdapter(iterable);
    }

    public static LazyCharIterable select(CharIterable iterable, CharPredicate predicate) {
        return new SelectCharIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(CharIterable iterable, CharToObjectFunction<? extends V> function) {
        return new CollectCharToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> flatCollect(CharIterable iterable, CharToObjectFunction<? extends Iterable<V>> function) {
        return new FlatCollectCharToObjectIterable(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(CharIterable iterable, CharPredicate predicate, CharToObjectFunction<? extends V> function) {
        return LazyCharIterate.select(iterable, predicate).collect((CharToObjectFunction)function);
    }

    public static LazyCharIterable empty() {
        return EMPTY_ITERABLE;
    }

    public static LazyCharIterable tap(CharIterable iterable, CharProcedure procedure) {
        return new TapCharIterable(iterable, procedure);
    }
}

