/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.eclipse.collections.impl.utility.primitive;

import shadow.palantir.driver.org.eclipse.collections.api.IntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIntIterable;
import shadow.palantir.driver.org.eclipse.collections.api.LazyIterable;
import shadow.palantir.driver.org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import shadow.palantir.driver.org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import shadow.palantir.driver.org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import shadow.palantir.driver.org.eclipse.collections.impl.factory.primitive.IntLists;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.CollectIntToObjectIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.FlatCollectIntToObjectIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.SelectIntIterable;
import shadow.palantir.driver.org.eclipse.collections.impl.lazy.primitive.TapIntIterable;

public final class LazyIntIterate {
    private static final LazyIntIterable EMPTY_ITERABLE = IntLists.immutable.empty().asLazy();

    private LazyIntIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyIntIterable adapt(IntIterable iterable) {
        return new LazyIntIterableAdapter(iterable);
    }

    public static LazyIntIterable select(IntIterable iterable, IntPredicate predicate) {
        return new SelectIntIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(IntIterable iterable, IntToObjectFunction<? extends V> function) {
        return new CollectIntToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> flatCollect(IntIterable iterable, IntToObjectFunction<? extends Iterable<V>> function) {
        return new FlatCollectIntToObjectIterable(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(IntIterable iterable, IntPredicate predicate, IntToObjectFunction<? extends V> function) {
        return LazyIntIterate.select(iterable, predicate).collect((IntToObjectFunction)function);
    }

    public static LazyIntIterable empty() {
        return EMPTY_ITERABLE;
    }

    public static LazyIntIterable tap(IntIterable iterable, IntProcedure procedure) {
        return new TapIntIterable(iterable, procedure);
    }
}

