/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.joda.time.convert;

import shadow.palantir.driver.org.joda.time.Chronology;
import shadow.palantir.driver.org.joda.time.DateTimeUtils;
import shadow.palantir.driver.org.joda.time.DateTimeZone;
import shadow.palantir.driver.org.joda.time.PeriodType;
import shadow.palantir.driver.org.joda.time.ReadablePartial;
import shadow.palantir.driver.org.joda.time.chrono.ISOChronology;
import shadow.palantir.driver.org.joda.time.convert.Converter;
import shadow.palantir.driver.org.joda.time.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        return DateTimeUtils.currentTimeMillis();
    }

    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        return ISOChronology.getInstance(dateTimeZone);
    }

    public Chronology getChronology(Object object, Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology) {
        long l = this.getInstantMillis(object, chronology);
        return chronology.get(readablePartial, l);
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        return this.getPartialValues(readablePartial, object, chronology);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chronology) {
        return false;
    }

    public String toString() {
        return "Converter[" + (this.getSupportedType() == null ? "null" : this.getSupportedType().getName()) + "]";
    }
}

