/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.mpierce.metrics.reservoir.hdrhistogram;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import shadow.palantir.driver.com.codahale.metrics.Snapshot;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.org.HdrHistogram.Histogram;
import shadow.palantir.driver.org.HdrHistogram.HistogramIterationValue;

final class HistogramSnapshot
extends Snapshot {
    private final Histogram histogram;

    HistogramSnapshot(@Nonnull Histogram histogram) {
        this.histogram = histogram;
    }

    @Override
    public double getValue(double quantile) {
        return this.histogram.getValueAtPercentile(quantile * 100.0);
    }

    @Override
    public long[] getValues() {
        long[] vals = new long[(int)this.histogram.getTotalCount()];
        int i = 0;
        for (HistogramIterationValue value : this.histogram.recordedValues()) {
            long val = value.getValueIteratedTo();
            int j = 0;
            while ((long)j < value.getCountAddedInThisIterationStep()) {
                vals[i] = val;
                ++i;
                ++j;
            }
        }
        if (i != vals.length) {
            throw new IllegalStateException("Total count was " + this.histogram.getTotalCount() + " but iterating values produced " + vals.length);
        }
        return vals;
    }

    @Override
    public int size() {
        return (int)this.histogram.getTotalCount();
    }

    @Override
    public long getMax() {
        return this.histogram.getMaxValue();
    }

    @Override
    public double getMean() {
        return this.histogram.getMean();
    }

    @Override
    public long getMin() {
        return this.histogram.getMinValue();
    }

    @Override
    public double getStdDev() {
        return this.histogram.getStdDeviation();
    }

    @Override
    public void dump(OutputStream output) {
        try (PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                int j = 0;
                while ((long)j < value.getCountAddedInThisIterationStep()) {
                    p.printf("%d%n", value.getValueIteratedTo());
                    ++j;
                }
            }
        }
    }
}

